/* <nage01.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library e01 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2146 (Feb 1998).
 * Mark 6 revised. IER-3028 (July 2000).
 */
#ifndef NAGE01
#define NAGE01

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL e01bac(Integer m, double x[], double y[],
                                             Nag_Spline *spline, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL e01bec(Integer n, double x[], double f[], double d[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL e01bfc(Integer n, double x[], double f[], double d[], Integer m, double px[],
                                             double pf[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL e01bgc(Integer n, double x[], double f[], double d[],
                                             Integer m, double px[], double pf[], double pd[],
                                             NagError *fail);
  extern void e01bgy(double x1, double x2, double f1, double f2,
                     double d1, double d2, Integer ne, double *xe,
                     double *fe, double *de, Integer * next, Integer *info);
  extern void e01bgz( Integer n, double x[],  double f[],   double d[],
                      Integer incfd,  Integer m, double px[],  double pf[],
                      double pd[], Integer *info);
  extern NAG_DLL_EXPIMP void NAG_CALL e01bhc(Integer n, double x[], double f[], double d[],
                                             double a, double b, double *integral, NagError *fail);
  extern double e01bhx(double x1, double x2, double f1, double f2,
                       double d1, double d2, double a, double b,
                       Integer *info);
  extern double e01bhy(Integer n, double x[], double f[], double d[],
                       Integer incfd, Boolean *skip, Integer ia, Integer ib,
                       Integer *info);
  extern double e01bhz(Integer n, double x[], double f[], double d[],
                       Integer incfd, double a, double b, Integer *info);
  extern NAG_DLL_EXPIMP void NAG_CALL e01dac(Integer mx, Integer my, double x[], double y[],
                                             double f[],Nag_2dSpline *spline, NagError *fail);
  extern void e01dal(Integer n, Integer ibandw, double ufctr[],
                     Integer nsets, Integer ntzero,
                     double theta[], Integer it1, Integer it2);
  extern void e01dam(Integer norder, Integer nknots, double xmin,
                     double xmax, double lambda[],
                     Integer jintvl, double knot[]);
  extern void e01dan(Integer nknots, double lambda[],
                     double x, Integer *jintvl);
  extern void e01dap(Integer nxdata, double xdata[], double x,
                     Integer *jintvl);
  extern void e01daq(Integer n, Integer nsets, Integer nufctr, double ufctr[],
                     double theta[], Integer it1,
                     Integer it2, double sfrss[],
                     Integer isf1, double srss[], Integer isr1);
  extern void e01dar(Integer n, Integer ibandw, Integer ixnzst,
                     double xrow[], Integer nsets, double yrow[],
                     Integer iy1,  Integer *lastcl,
                     double ufctr[],  double theta[],
                     Integer it1, Integer it2, double wrk[]);
  extern void e01das(Integer n, Integer ibandw, double ufctr[], Integer *info);
  extern void e01dat(Integer norder, double *knot,
                     double x, double *basis);
  extern void e01dau(Integer nxdata, double xdata[], double x,
                     Integer *j);
  extern void e01dav(Integer norder, double knot[],
                     double x, double basis[]);
  extern void e01daw(Integer norder, double xmin, double xmax,
                     Integer m, double x[], Integer nsets, double f[],
                     Integer if1, Integer if2, Integer nknots,
                     double lambda[], double c[], Integer ic1,
                     Integer ic2, double ufctr[],  double knot[],
                     double *xrow, double *wrk,   Integer *info);
  extern void e01dax(double xmin, double xmax, Integer m, double x[],
                     double w[], Integer iw1, Integer *ifnzwt,
                     Integer *mnzwt, Integer *mdnzwt, Integer *info);
  extern void e01day(Integer norder, Integer nknots, Integer m, double x[],
                     double w[], Integer iw1, Integer ifnzwt,
                     Integer mdnzwt, double lambda[]);
  extern void e01daz(Integer  nxordr, Integer nxknts, double xmin,
                     double xmax, Integer nyordr, Integer nyknts,
                     double ymin, double ymax, Integer mx,
                     double x[], Integer my, double y[], double f[],
                     Integer if1, Integer if2, double xlam[],
                     double ylam[],double c[], Integer ic1, Integer ic2, 
                     double xufctr[],  double yufctr[],
                     double e[], Integer ie1, Integer ie2,
                     double xknot[], double yknot[], double xrow[],
                     double yrow[], double wrk[], Integer *info);
  extern NAG_DLL_EXPIMP void NAG_CALL e01sac(Nag_2d_Scat_Method method, Integer m, double x[], double y[],
                                             double f[], Nag_Scat_Struct *comm, Nag_E01_Opt *optional,
                                             NagError *fail);
  extern void e01saq(Integer nfrst, Integer nlast, Integer kk, Integer iarr[]);
  extern Integer e01sar(Integer nvertx, Integer nabor, Integer iadj[], Integer iend[]);
  extern void e01sas(Integer nin1, Integer nin2, Integer nout1, Integer nout2,
                     Integer iadj[], Integer iend[]);
  extern Boolean e01sat(Integer in1, Integer in2, Integer io1, Integer io2,
                        double x[], double y[]);
  extern void e01sau(Integer kk, Integer i1, Integer i2, Integer iadj[], Integer iend[]);
  extern void e01sav(Integer kk, Integer i1, Integer i2, Integer i3,
                     Integer iadj[], Integer iend[]);
  extern void e01saw(Integer nst, double px, double py, double x[], double y[],
                     Integer iadj[], Integer iend[], Integer *i1, Integer *i2,
                     Integer *i3);
  extern void e01sax(Integer kk, double x[], double y[], Integer iadj[],
                     Integer iend[], Integer *ier);
  extern void e01say(Integer n, double x[], double y[], Integer iadj[],
                     Integer iend[], Integer *ier);
  extern void e01saz(Integer n, double x[], double y[], double z[], Integer iadj[],
                     Integer iend[], double eps, Integer *nit, double zxzy[],
                     Integer *coinc1, Integer *coinc2, Integer *ier);
  extern NAG_DLL_EXPIMP void NAG_CALL e01sbc(Nag_Scat_Struct *comm, Integer n, double px[], double py[],
                                             double pf[], NagError *fail);
  extern void e01sby(double x, double y, double x1, double x2,
                     double x3, double y1, double y2, double y3,
                     double z1, double z2, double z3, double zx1,
                     double zx2, double zx3, double zy1, double zy2,
                     double zy3, Integer iflag, double *w, double *wx,
                     double *wy, Integer *ier);
  extern void e01sbz(Integer n, double px, double py, double x[],
                     double y[], double z[], Integer iadj[], Integer iend[],
                     double zxzy[], Integer *ist, Integer iflag,
                     double *pz, double *dzx, double *dzy, Integer *ier);
  extern void e01sez(Integer n, double x[], double y[], double z[], double rnq,
                     double fnodes[], Integer *minnq, double c[], double b[]);
  extern NAG_DLL_EXPIMP void NAG_CALL e01szc(Nag_Scat_Struct *comm);

  extern NAG_DLL_EXPIMP void NAG_CALL e01aec(Integer m, double xmin, double xmax, const double x[], const double y[], const Integer p[], Integer itmin, Integer itmax, double a[], double perf[], Integer *num_iter, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL e01rac(Integer n, const double x[], const double f[], Integer *m, double a[], double u[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL e01rbc(Integer m, const double a[], const double u[], double x, double *f, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL e01sgc(Integer m, const double x[], const double y[], const double f[], Integer nw, Integer nq, Integer iq[], double rq[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL e01shc(Integer m, const double x[], const double y[], const double f[], const Integer iq[], const double rq[], Integer n, const double u[], const double v[], double q[], double qx[], double qy[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL e01tgc(Integer m, const double x[], const double y[], const double z[], const double f[], Integer nw, Integer nq, Integer iq[], double rq[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL e01thc(Integer m, const double x[], const double y[], const double z[], const double f[], const Integer iq[], const double rq[], Integer n, const double u[], const double v[], const double w[], double q[], double qx[], double qy[], double qz[], NagError *fail); 
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGE01 */
